NewVZones = NewVZones or {}

local excludedParts = {
	Engine = true,
	Heater = true,
	GloveBox = true,
	TruckBed = true,
	PassengerCompartment = true,
	SeatFrontLeft = true
}

NewVZones._pendingRemovals = NewVZones._pendingRemovals or {}

local function removeBrokenParts(vehicle, part)
	if not instanceof(part, "VehiclePart") then return end
	local item = part:getInventoryItem()
	part:setInventoryItem(nil)
	if item then
		item:setItemCapacity(part:getContainerContentAmount())
	end
	vehicle:transmitPartItem(part)
end

local function scheduleVehicleRemoval(vehicle, delayTicks)
	if not vehicle then return end
	for _, e in ipairs(NewVZones._pendingRemovals) do
		if e.vehicle == vehicle then return end
	end
	table.insert(NewVZones._pendingRemovals, { vehicle = vehicle, delay = delayTicks or 1 })
end

local function processPendingRemovals()
	local q = NewVZones._pendingRemovals
	if not q or #q == 0 then return end
	for i = #q, 1, -1 do
		local entry = q[i]
		entry.delay = entry.delay - 1
		if entry.delay <= 0 then
			local ok, err = pcall(function()
				local v = entry.vehicle
				if v then
					v:permanentlyRemove()
				end
			end)
			if not ok then
			end
			table.remove(q, i)
		end
	end
end

if not NewVZones._tickHandlerAdded then
	Events.OnTick.Add(processPendingRemovals)
	NewVZones._tickHandlerAdded = true
end

function NewVZones.GamestaOnSpawnVehicleEndActions(vehicle)
	if not vehicle:getChunk():isNewChunk() then return end
	local pos = vehicle:getSquare()
	local zone = getVehicleZoneAt(pos:getX(), pos:getY(), 0)

	if zone ~= nil then
		local zoneName = zone:getName()
		local rand = newrandom()


	-- Car Flipper
		if zone == getVehicleZoneAt(7744, 11889, 0) then
			vehicle:setDebugZ(.4) --So it doesn't clip into the ground, raise it! (BUS)
			vehicle:setAngles(180, 120, -90)
		end
		
	--Vehicles Left Abandoned (Day 1 apoclypse settings, should be auto disabled beyond 1 week at most)
--		if zoneName ~= "Junkyard" then
--			print("NOTaJunkyard")
--			if not vehicle:isEngineRunning() then
--				print("check:1.1")
--				local Engine = vehicle:getPartById("Engine")
--				if Engine then
--					print("check:1.2")
--					if Engine:getCondition() < 10 then
--						Engine:setCondition(rand:random(10, 100))
--						print("Engine:setCondition(rand:random(10, 100)):")
--						print(vehicle)
--					end
--				end
--
--				local i = 2
--				local function startVehicle()
--					i = i - 1
--					if i > 0 then return end
--					local GasTank = vehicle:getPartById("GasTank")
--					if GasTank and GasTank:isContainer() and GasTank:getContainerContentType() then
--						print("check:3.1")
--						print(vehicle:isKeysInIgnition())
--						if vehicle:isKeysInIgnition() then
--							GasTank:setContainerContentAmount(rand:random(10, 100))
--							vehicle:engineDoRunning()
--							print("engineDoRunning()")
--							print(vehicle)
--						else
--							GasTank:setContainerContentAmount(0)
--							print("GasTank:setContainerContentAmount(0)")
--							print(vehicle)
--						end
--					end
--					Events.OnTick.Remove(startVehicle)
--				end
--
--				print(vehicle:isKeysInIgnition())
--				if not vehicle:isKeysInIgnition() then
--					print("check:2.1")
--					local randCarIgnited = rand:random(1, 100)
--					if randCarIgnited < 101 then
--					--	vehicle:setKeysInIgnition(true) --DOESN'T WORK?
--						local key = vehicle:createVehicleKey()
--						vehicle:getSquare():AddWorldInventoryItem(key, 0.5, 0.5, 0 )
--						vehicle:putKeyInIgnition(key, ???)--key:getWorldItem():getItemContainer():getID())??? I'M STUMPED HERE!
--						print("keys in")
--						print(vehicle)
--						Events.OnTick.Add(startVehicle)
--					elseif randCarIgnited < 90 then
--						vehicle:setHotwired(true)
--						print("hotwired")
--						print(vehicle)
--						Events.OnTick.Add(startVehicle)
--					elseif randCarIgnited < 100 then
--						vehicle:setHotwiredBroken(true)
--						print("broken hotwire")
--						print(vehicle)
--					end
--				else
--					print("keys already in")
--					print(vehicle)
--					Events.OnTick.Add(startVehicle)
--				end
--
--			end
--		end

		if zoneName == "modified_trfjm" or zoneName == "junkyard" or zoneName == "trafficjamn" or zoneName == "trafficjams" or zoneName == "trafficjame" or zoneName == "trafficjamw" then
	
		-- Remove Good Vehicles
			if vehicle:getScriptName() ~= "Base.SemiTrailerLowBed" and vehicle:isGoodCar() then
				scheduleVehicleRemoval(vehicle, 1)
			end

			if zoneName ~= "Junkyard" then
			
			-- Car Angles
				if zoneName == "modified_trfjm" then
					local randDirY = rand:random(-10, 10)
					if zone == getVehicleZoneAt(12599, 1274, 0) then vehicle:setAngles(180, randDirY, 180)
					elseif zone == getVehicleZoneAt(12593, 1274, 0) then vehicle:setAngles(0, randDirY, 0)
					elseif zone == getVehicleZoneAt(12506, 1241, 0) then vehicle:setAngles(180, randDirY, 180)
					elseif zone == getVehicleZoneAt(12501, 1241, 0) then vehicle:setAngles(0, randDirY, 0)
					end
				elseif zoneName == "trafficjamn" then
					local randDirY = rand:random(-30, 30)
					vehicle:setAngles(180, randDirY, 180)
				elseif zoneName == "trafficjams" then
					local randDirY = rand:random(-30, 30)
					vehicle:setAngles(0, randDirY, 0)
				elseif zoneName == "trafficjame" then
					local randDirY = rand:random(60, 120)
					vehicle:setAngles(0, randDirY, 0)
				elseif zoneName == "trafficjamw" then
					local randDirY = rand:random(60, 120)
					vehicle:setAngles(0, -randDirY, 0)
				end
			
			elseif zoneName == "junkyard" then
				
			-- Junkyard Parts
				if vehicle:getScriptName() ~= "Base.SemiTrailerLowBed" then
					if not (vehicle:isGoodCar() or vehicle:isBurnt()) then
						local battery = vehicle:getBattery()
						if not battery then return end
						local batteryInvItem = battery:getInventoryItem()
						if not batteryInvItem then return end
						batteryInvItem:setCurrentUsesFloat(0.0)
					end

					local rearWindowCandidates = {
						"WindshieldRear",
						"WindshieldRear2",
						"WindowTrunk",
						"WindowTrunkRear",
						"WindowRear",
						"WindowRearLeft",
						"WindowRearRight",
						"WindowBack",
						"RearWindow"
					}
					for i = vehicle:getPartCount() - 1, 0, -1 do
						local part = vehicle:getPartByIndex(i)
						if part then
							local partName = part:getId()
							if partName == "SeatFrontLeft" then
							else
								if part:getCondition() == 0 and not excludedParts[partName] then
									if string.sub(partName, 1, 4) == "Door" then
										local doorSide = string.sub(partName, 5)
										local windowPart = vehicle:getPartById("Window" .. doorSide)
										removeBrokenParts(vehicle, part)
										if windowPart then removeBrokenParts(vehicle, windowPart) end
									elseif partName == "TrunkDoor" or partName == "DoorRear" or string.find(partName, "Trunk") or string.find(partName, "Boot") then
										removeBrokenParts(vehicle, part)
										for _, rearId in ipairs(rearWindowCandidates) do
											local rearPart = vehicle:getPartById(rearId)
											if rearPart then removeBrokenParts(vehicle, rearPart) end
										end
									elseif string.sub(partName, 1, 10) == "Suspension" or string.sub(partName, 1, 5) == "Brake" then
										removeBrokenParts(vehicle, part)
										local side = nil
										if string.sub(partName, 1, 10) == "Suspension" then
											side = string.sub(partName, 11)
										else
											side = string.sub(partName, 6)
										end
										if side and side ~= "" then
											local tirePart = vehicle:getPartById("Tire" .. side)
											if tirePart then
												removeBrokenParts(vehicle, tirePart)
											end
										end
									else
										removeBrokenParts(vehicle, part)
									end
								end
							end
						end
					end
				end

			end

		end
		
		-- Remove/Replace Oversized Vehicles Indoors (current work around is using custom zones, could be better)
--		if zoneName == "firegarage" then
--			if vehicle:getScriptName() == ("Base.90pierceArrow" or "Base.pzkFireTruckFlatLadder") then
--				local vDir = vehicle:getForwardIsoDirection()
--				scheduleVehicleRemoval(vehicle, 1)
--				if not (getActivatedMods():contains("\\NoVanillaVehicles") or getActivatedMods():contains("\\VVR")) then
--					local fireVehicles = {"Base.PickUpVanLightsFire", "Base.PickUpTruckLightsFire"}
--					local fire = fireVehicles[ZombRand(1, #fireVehicles + 1)]
--					if pos:getX() and pos:getY() then
--						vehicle = addVehicle(fire, pos:getX(), pos:getY(), 0)
--						if vehicle then
--							if vDir == IsoDirections.N then vehicle:setAngles(0, 180, 0)
--							elseif vDir == IsoDirections.S then vehicle:setAngles(0, 0, 0)
--							elseif vDir == IsoDirections.E then vehicle:setAngles(0, 90, 0)
--							elseif vDir == IsoDirections.W then vehicle:setAngles(0, -90, 0)
--							end
--						end
--					end
--				end
--			end
--		end

	end
	
end

Events.OnSpawnVehicleEnd.Add(NewVZones.GamestaOnSpawnVehicleEndActions)